//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: P70 is an external event input.
//				  When P70 signals a falling edge, the counter value is incremented by one. 
//				  When the counter value is the same as T00REG, the TC00 interrupt occurs.
//				  At this point, P90 output level is inverted. 
//****************************************** 
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6811.h"
void main()
{	
	WDCDR.byte = 0x4e;		//clear WDT
    P7CR.bit.b0=0;			//set P70 as TC00 event input pin
	
	P9CR.bit.b0=1;
	
    __asm("DI");
	POFFCR0.byte=0x10; 		//enable TC00 and TC01 
	EIRH.bit.b4= 1; 		//enable TC00 interrupt
	__asm("EI");
	T00MOD.byte=0xFC;		//<DBE0>=1,<EIN0>=1,<TCM0>=0 8-bit event counter mode
	T00REG.byte=0x05	; 		//set timer value
	
	T001CR.bit.b0=1; 		//start TC00  
    while(1)
	{
		WDCDR.byte = 0x4e;	//clear WDT
	}   
       
   
}